<?php

namespace App\Filament\Resources;

use App\Filament\Resources\OrderResource\Pages;
use App\Filament\Resources\OrderResource\RelationManagers;
use App\Models\Order;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

use Filament\Forms\Components\Select;
use Filament\Forms\Components\TextInput;
use Filament\Tables\Columns\BadgeColumn;
use Filament\Tables\Columns\TextColumn;

class OrderResource extends Resource
{
    protected static ?string $model = Order::class;
    protected static ?string $pluralModelLabel = 'سفارش ها';

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

   public static function form(Form $form): Form
{
    return $form
        ->schema([
            // این فیلدها فقط برای نمایش هستند و غیرفعال می‌شوند
            TextInput::make('user.name')->label('نام کاربر')->disabled(),
            TextInput::make('product_name')->label('نام محصول')->disabled(),
            TextInput::make('price')->label('قیمت (سکه)')->disabled(),
            
            // تنها فیلدی که ادمین می‌تواند ویرایش کند
            Select::make('status')
                ->options([
                    'pending' => 'در انتظار', 
                    'completed' => 'تکمیل شده', 
                    'failed' => 'لغو شده'
                ])
                ->label('وضعیت سفارش')
                ->required(),
        ]);
}

public static function getEloquentQuery(): Builder
{
    return parent::getEloquentQuery()->with(['user']);
}
public static function table(Table $table): Table
{
    return $table
        ->columns([
            TextColumn::make('id')->sortable(),
            TextColumn::make('user.name')->label('نام')->searchable(),
            TextColumn::make('product_name')->label('محصول')->searchable(),
            TextColumn::make('price')->label('سکه مصرفی')->sortable(),
            BadgeColumn::make('status') // نمایش وضعیت با رنگ‌های مختلف
                ->colors([
                    'success' => 'completed',
                    'warning' => 'pending',
                    'danger' => 'failed',
                ])
                ->label('وضعیت'),
            TextColumn::make('created_at')->label('زمان سفارش')->dateTime(),
        ])
        ->defaultSort('created_at', 'desc'); // مرتب سازی بر اساس جدیدترین سفارش
}

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListOrders::route('/'),
            'create' => Pages\CreateOrder::route('/create'),
            'edit' => Pages\EditOrder::route('/{record}/edit'),
        ];
    }
}
