<?php

namespace App\Filament\Resources;

use App\Filament\Resources\ProductResource\Pages;
use App\Filament\Resources\ProductResource\RelationManagers;
use App\Models\Product;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;



use Filament\Forms\Components\TextInput;




class ProductResource extends Resource
{
    protected static ?string $model = Product::class;
        protected static ?string $pluralModelLabel = 'محصولات';


    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                // 1. فیلد نام (برای حل خطای 'Field 'name' doesn't have a default value')
                TextInput::make('name')
                    ->label('نام محصول')
                    ->required() // الزامی است (چون در DB مقدار پیش‌فرض ندارد)
                    ->maxLength(255),

                // 2. فیلد قیمت (برای تراکنش‌های سکه در ربات)
                TextInput::make('price')
                    ->label('قیمت (سکه)')
                    ->required()
                    ->numeric() // فقط اعداد را می‌پذیرد
                    ->suffix('سکه'),
                
                // 3. فیلد موجودی (چند عدد از این محصول موجود است)
                TextInput::make('quantity')
                    ->label('موجودی')
                    ->required()
                    ->numeric()
                    ->default(1),

                // 4. فیلد دیتای محصول (کلید، لینک فایل و...)
                TextInput::make('data')
                    ->label('دیتای محصول (کلید/لینک)')
                    ->helperText('این مقدار پس از خرید به کاربر نمایش داده می‌شود.')
                    ->nullable() // می‌تواند خالی باشد
                    ->columnSpanFull(), // تمام عرض فرم را اشغال می‌کند
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('name')
                    ->label('نام محصول')
                    ->searchable()
                    ->sortable(),
                Tables\Columns\TextColumn::make('price')
                    ->label('قیمت'),
                Tables\Columns\TextColumn::make('quantity')
                    ->label('موجودی'),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListProducts::route('/'),
            'create' => Pages\CreateProduct::route('/create'),
            'edit' => Pages\EditProduct::route('/{record}/edit'),
        ];
    }
}
