<?php

namespace App\Filament\Resources;

use App\Filament\Resources\TaskResource\Pages;
use App\Filament\Resources\TaskResource\RelationManagers;
use App\Models\Task;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

use Filament\Forms\Components\TextInput;
use Filament\Forms\Components\Textarea;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\Toggle;

use Filament\Tables\Columns\TextColumn;
use Filament\Tables\Columns\IconColumn;

class TaskResource extends Resource
{
    protected static ?string $model = Task::class;
    protected static ?string $pluralModelLabel = 'تسک ها';

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                // 1. عنوان وظیفه (از ستون 'title')
                TextInput::make('title')
                    ->label('عنوان وظیفه')
                    ->required()
                    ->maxLength(255)
                    ->columnSpanFull(),

                // 2. توضیحات
                Textarea::make('description')
                    ->label('توضیحات کامل')
                    ->nullable()
                    ->rows(4)
                    ->columnSpanFull(),

                // 3. پاداش (از ستون 'reward')
                TextInput::make('reward')
                    ->label('مقدار پاداش (سکه)')
                    ->required()
                    ->numeric()
                    ->suffix('سکه')
                    ->minValue(1),

                // 4. لینک (برای وظایف عضویت یا بازدید)
                TextInput::make('link')
                    ->label('لینک/آدرس هدف')
                    ->url() // اعتبار سنجی برای URL
                    ->nullable()
                    ->columnSpanFull(),
                
                // 5. وضعیت فعال بودن (از ستون 'is_active')
                Toggle::make('is_active')
                    ->label('وظیفه فعال باشد؟')
                    ->default(true),

            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                // 1. ID
                TextColumn::make('id')->sortable(),

                // 2. عنوان وظیفه (از ستون 'title')
                TextColumn::make('title')
                    ->label('عنوان وظیفه')
                    ->searchable()
                    ->sortable(),

                // 3. پاداش (از ستون 'reward')
                TextColumn::make('reward')
                    ->label('پاداش')
                    ->suffix(' سکه')
                    ->sortable(),
                
                // 4. فعال بودن (با آیکون)
                IconColumn::make('is_active')
                    ->label('وضعیت')
                    ->boolean()
                    ->trueIcon('heroicon-o-check-circle')
                    ->falseIcon('heroicon-o-x-circle')
                    ->colors([
                        'success' => true,
                        'danger' => false,
                    ]),

                // 5. تاریخ ایجاد
                TextColumn::make('created_at')
                    ->label('تاریخ ایجاد')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListTasks::route('/'),
            'create' => Pages\CreateTask::route('/create'),
            'edit' => Pages\EditTask::route('/{record}/edit'),
        ];
    }
}
