<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;


class Order extends Model
{
    use HasFactory;
    
    // ⚠️ غیرفعال کردن آپدیت زمان (جدول شما updated_at ندارد)
    public $timestamps = false; 

    protected $fillable = [
        'chat_id', 'product_id', 'product_name', 'price', 'status',
    ];

    // اگر می‌خواهید کاربر مربوط به سفارش را نمایش دهید
    public function user()
    {
        // رابطه با مدل User بر اساس ستون chat_id (چون در orders از chat_id استفاده شده)
        return $this->belongsTo(User::class, 'chat_id', 'chat_id' , 'name');
    }
    
}