<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;


class TaskSubmission extends Model
{
    protected $table = 'task_submissions';
    public $timestamps = false; // این جدول فقط created_at دارد که توسط MySQL مدیریت می‌شود

    protected $fillable = [
        'user_id', 'chat_id', 'task_id', 'proof_text', 'proof_file_id', 'status'
    ];

    // ارتباط با کاربر ارسال کننده
    public function user()
    {
       return $this->belongsTo(User::class, 'user_id', 'id');
    }

    // ارتباط با تسک مربوطه
    public function task()
    {
        return $this->belongsTo(Task::class, 'task_id', 'id');
    }
}

