<?php
// check_submissions.php

error_reporting(E_ALL);
ini_set('display_errors', 0); // برای محیط Cron Job، نمایش خطا را خاموش کنید

// فراخوانی فایل‌های اصلی
require_once __DIR__ . '/config.php';
require_once __DIR__ . '/db.php';     // باید $conn یا متغیر اتصال به دیتابیس را فراهم کند
require_once __DIR__ . '/function.php';

global $conn;
if (!$conn) { // 👈 تغییر: چک می‌کنیم که $conn برقرار شده باشد.
    error_log("Database connection failed in check_submissions.php");
    exit;
}

// 2. کوئری: یافتن تسک‌های تایید/رد شده که هنوز پیامشان نرفته است
try {
    // 💡 تغییر: کوئری را باید با استفاده از متدهای mysqli اجرا کنید.
    // در اینجا، چون از PDO استفاده نکردید، کوئری باید با متد prepare/execute کلاس mysqli اجرا شود.

    $stmt = $conn->prepare("
        SELECT 
            ts.id as submission_id,
            ts.chat_id,
            ts.status,
            ts.rejection_reason,
            t.title as task_title,
            t.reward
        FROM task_submissions ts
        JOIN tasks t ON ts.task_id = t.id
        WHERE (ts.status = 'approved' OR ts.status = 'rejected') 
          AND ts.is_notified = 0 
        LIMIT 50
    ");
    $stmt->execute();

    // دریافت نتایج
    $result = $stmt->get_result();
    $submissions = $result->fetch_all(MYSQLI_ASSOC);
} catch (\mysqli_sql_exception $e) {
    error_log("DB Query Error: " . $e->getMessage());
    exit;
}
// 3. پردازش و ارسال پیام
foreach ($submissions as $sub) {
    $message_to_send = '';
    $submission_id = $sub['submission_id'];

    if ($sub['status'] === 'approved') {
        $reward = (int)$sub['reward'];
        $task_title = htmlspecialchars($sub['task_title']);
        $message_to_send = "🎉 **تایید شد!**\nوظیفه شما با عنوان **{$task_title}** توسط ادمین تایید شد و **{$reward} سکه** به حساب شما واریز گردید.";
    } elseif ($sub['status'] === 'rejected') {
        $reason = htmlspecialchars($sub['rejection_reason'] ?? 'بدون توضیح');
        $task_title = htmlspecialchars($sub['task_title']);
        $message_to_send = "❌ **رد شد!**\nمتاسفانه وظیفه **{$task_title}** شما توسط ادمین رد شد.\n\n**علت رد:** {$reason}";
    }

    // اگر پیامی برای ارسال داریم
    if ($message_to_send) {
        // فرض می‌کنیم تابع sendMessage از parse_mode: HTML استفاده می‌کند
        $sent_successfully = sendMessage($sub['chat_id'], $message_to_send);

        if ($sent_successfully) {
            try {
                // 💡 اصلاح: استفاده از نحوه‌ی prepare/bind_param/execute برای mysqli
                $update_stmt = $conn->prepare("UPDATE task_submissions SET is_notified = 1 WHERE id = ?"); // استفاده از Placeholder علامت سوال (?)

                // تعیین نوع و مقدار پارامتر: i یعنی Integer
                $update_stmt->bind_param("i", $submission_id);
                $update_stmt->execute();

                // بررسی موفقیت‌آمیز بودن اجرا (اختیاری)
                if ($update_stmt->affected_rows > 0) {
                    error_log("Notification sent and marked for submission ID: $submission_id");
                } else {
                    error_log("DB Update Warning: Could not mark submission ID $submission_id. It might already be marked.");
                }

                $update_stmt->close(); // بستن Statement

            } catch (\mysqli_sql_exception $e) { // 💡 اصلاح: استفاده از catch برای mysqli
                error_log("DB Update Error for submission $submission_id: " . $e->getMessage());
            }
        }
    }
}

// این برای خروجی Cron Job است، می‌توانید آن را حذف کنید.
// echo "Checked " . count($submissions) . " submissions.";
