<?php

function getBotId(){
    global $botToken; // باید در config.php تعریف شده باشد
    $result = botRequest('getMe');
    return $result['ok'] ? $result['result']['id'] : null;
}
$botId = getBotId();

function botRequest($method, $data = []){
    global $botToken; // باید در config.php تعریف شده باشد
    $url = "https://api.telegram.org/bot$botToken/$method";
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $result = curl_exec($ch);
    curl_close($ch);
    return $result ? json_decode($result, true) : false;
}

// Check user membership in the channel using Telegram API
// نسخه اصلاح شده برای عیب‌یابی (Debug)
function isUserMemberOfChannel($chat_id, $channel_username){
    global $botToken;
    
    // اطمینان از وجود @ در ابتدای یوزرنیم
    if (strpos($channel_username, '@') !== 0 && is_numeric($channel_username) === false) {
        $channel_username = '@' . $channel_username;
    }

    $url = "https://api.telegram.org/bot$botToken/getChatMember?chat_id=$channel_username&user_id=$chat_id";
    
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $result = curl_exec($ch);
    
    // بررسی خطای Curl
    if (curl_errno($ch)) {
        error_log("Curl Error in isUserMemberOfChannel: " . curl_error($ch));
        curl_close($ch);
        return false;
    }
    
    curl_close($ch);
    $json = json_decode($result, true);

    // بررسی خطای تلگرام
    if(!isset($json['ok']) || !$json['ok']) {
        // این خط دلیل خطا را در ارور لاگ هاست شما ذخیره می‌کند
        error_log("Telegram API Error (getChatMember): " . ($json['description'] ?? 'Unknown Error'));
        // اگر می‌خواهید موقتا برای تست خطا را در تلگرام بفرستید (پیشنهاد نمی‌شود)، این را فعال کنید:
        // sendMessage($chat_id, "Debug: " . ($json['description'] ?? 'Err')); 
        return false;
    }

    $status = $json['result']['status'] ?? '';
    // وضعیت‌های مورد قبول
    return in_array($status, ['creator', 'administrator', 'member', 'restricted']);
}

// در فایل function.php یا همان جایی که sendMessage را تعریف کرده‌اید
function sendMessage($chat_id, $text, $keyboard = null){
    global $botToken;
    
    // 💡 عیب یابی توکن: اگر $botToken خالی باشد، URL اشتباه می‌شود
    if (empty($botToken)) {
        error_log("FATAL: botToken is not set in sendMessage function.");
        return false;
    }
    
    $url = "https://api.telegram.org/bot$botToken/sendMessage";

    $data = [
        'chat_id' => $chat_id,
        'text' => $text,
        'parse_mode' => 'HTML'
    ];

    if ($keyboard) {
        $data['reply_markup'] = json_encode($keyboard);
    }
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    
    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    
    // 📢 گزارش دهی خطا
    if ($http_code != 200 || curl_errno($ch)) {
        $error_msg = "Telegram API Error | Code: $http_code | cURL Error: " . curl_error($ch) . " | Response: $response | Data: " . json_encode($data);
        error_log($error_msg);
        
        // اگر در حال تست مستقیم هستید، می‌توانید خطا را نمایش دهید
        // echo "<pre>DEBUG: $error_msg</pre>";
    }

    curl_close($ch);
    
    return true;
}

// Display the main user panel
function showMainPanel($chat_id) {
    global $conn; // برای دسترسی به اتصال دیتابیس
    global $channel_username; // برای نمایش لینک کانال در صورت لزوم

    // 1. خواندن وضعیت ثبت نام کاربر
    $stmt = $conn->prepare("SELECT registration_step FROM users WHERE chat_id = ?");
    $stmt->bind_param("i", $chat_id);
    $stmt->execute();
    $stmt->bind_result($uStep);
    $stmt->fetch();
    $stmt->close();

    // 2. بررسی وضعیت
    if ($uStep === NULL) {
        // ✅ ثبت نام کامل است: پنل کاربری اصلی را نمایش بده
        $keyboard = [
            'keyboard' => [
                [['text' => "💰 مشاهده سکه‌ها"], ['text' => "🛒 فروشگاه"]],
                [['text' => "📋 انجام تسک و درآمد"], ['text' => "✅ بررسی عضویت در کانال"]],
                [['text' => "🔗 آمار اعضا"], ['text' => "🎛 پنل کاربری"]]
            ],
            'resize_keyboard' => true
        ];
        sendMessage($chat_id, "🎉 پنل کاربری شما:", $keyboard);

    } else {
        // ❌ ثبت نام کامل نیست: کاربر را به مرحله فعلی ثبت نام هدایت کن
        $message = "لطفاً مراحل ثبت نام را تکمیل کنید.";
        $keyboard = null;

        if ($uStep == 'name') {
            $message = "سلام 👋\nلطفاً نام و نام خانوادگی خود را وارد کنید:";
        } elseif ($uStep == 'job') {
            $message = "✅ نام ثبت شد. شغل خود را وارد کنید:";
        } elseif ($uStep == 'phone') {
            // چک کردن عضویت در کانال قبل از نمایش کیبورد شماره
            if (!isUserMemberOfChannel($chat_id, $channel_username)) {
                $keyboard = ['keyboard' => [[['text' => "✅ بررسی عضویت در کانال"]]], 'resize_keyboard' => true];
                $message = "لطفاً ابتدا عضو کانال شوید:\n{$channel_username}";
            } else {
                $keyboard = ['keyboard' => [[['text' => '📱 ارسال شماره تلفن', 'request_contact' => true]]], 'resize_keyboard' => true];
                $message = "شماره تلفن خود را ارسال کنید:";
            }
        }
        
        sendMessage($chat_id, $message, $keyboard);
    }
}
?>